/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.DNSAndIPAddrListBoxesInterface;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.HashSet;
import java.util.Iterator;

public class ModifyCertBean
extends PanelBean
implements CertMgtConstants,
DNSAndIPAddrListBoxesInterface {
    private static final String TRACE_MASKD = "XCRTMODD";
    private static final String TRACE_MASKF = "XCRTMODF";
    private static final String TRACE_MASKT = "XCRTMODT";
    private ServerCert certificate = null;
    private String m_sDNSEntry;
    private String m_sDNSListBox;
    private ValueDescriptor[] m_vdDNSListBox;
    private String m_sIPAddrNetworkByte0;
    private String m_sIPAddrNetworkByte1;
    private String m_sIPAddrNetworkByte2;
    private String m_sIPAddrNetworkByte3;
    private String m_sIPAddrListBox;
    private ValueDescriptor[] m_vdIPAddrListBox;

    public ModifyCertBean(ServerCert certificate, String name) {
        this.certificate = certificate;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->ModifyCertBean(" + certificate + ", " + ", " + name + ")");
    }

    public void setDNSEntry(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setDNSEntry(" + s + ")");
        this.m_sDNSEntry = s;
    }

    public String getDNSEntry() {
        Trace.trace(TRACE_MASKT, "<->getDNSEntry() returning " + this.m_sDNSEntry);
        return this.m_sDNSEntry;
    }

    public ValueDescriptor[] getDNSListBoxList() {
        Trace.trace(TRACE_MASKT, "<->getDNSListBoxList() returning " + this.m_vdDNSListBox);
        return this.m_vdDNSListBox;
    }

    public void setDNSListBoxList(ValueDescriptor[] values) {
        Trace.trace(TRACE_MASKT, "<->setDNSListBoxList(" + values + ")");
        this.m_vdDNSListBox = values;
    }

    public void setDNSListBox(String s) {
        Trace.trace(TRACE_MASKT, "<->setDNSListBox(" + s + ")");
        this.m_sDNSListBox = s;
    }

    public String getDNSListBox() {
        Trace.trace(TRACE_MASKT, "<->getDNSListBox() returning " + this.m_sDNSListBox);
        return this.m_sDNSListBox;
    }

    public void setIPAddrNetworkByte0(String s) throws IllegalUserDataException {
        boolean valueToSet = false;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte0(" + s + ")");
        this.m_sIPAddrNetworkByte0 = s;
    }

    public String getIPAddrNetworkByte0() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte0() returning " + this.m_sIPAddrNetworkByte0);
        return this.m_sIPAddrNetworkByte0;
    }

    public void setIPAddrNetworkByte1(String s) throws IllegalUserDataException {
        boolean valueToSet = false;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte1(" + s + ")");
        this.m_sIPAddrNetworkByte1 = s;
    }

    public String getIPAddrNetworkByte1() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte1() returning " + this.m_sIPAddrNetworkByte1);
        return this.m_sIPAddrNetworkByte1;
    }

    public void setIPAddrNetworkByte2(String s) throws IllegalUserDataException {
        boolean valueToSet = false;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte2(" + s + ")");
        this.m_sIPAddrNetworkByte2 = s;
    }

    public String getIPAddrNetworkByte2() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte2() returning " + this.m_sIPAddrNetworkByte2);
        return this.m_sIPAddrNetworkByte2;
    }

    public void setIPAddrNetworkByte3(String s) throws IllegalUserDataException {
        boolean valueToSet = false;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte3(" + s + ")");
        this.m_sIPAddrNetworkByte3 = s;
    }

    public String getIPAddrNetworkByte3() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte3() returning " + this.m_sIPAddrNetworkByte3);
        return this.m_sIPAddrNetworkByte3;
    }

    public ValueDescriptor[] getIPAddrListBoxList() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrListBoxList() returning " + this.m_vdIPAddrListBox);
        return this.m_vdIPAddrListBox;
    }

    public void setIPAddrListBoxList(ValueDescriptor[] values) {
        Trace.trace(TRACE_MASKT, "<->setIPAddrListBoxList(" + values + ")");
        this.m_vdIPAddrListBox = values;
    }

    public void setIPAddrListBox(String s) {
        Trace.trace(TRACE_MASKT, "<->setIPAddrListBox(" + s + ")");
        this.m_sIPAddrListBox = s;
    }

    public String getIPAddrListBox() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrListBox() returning " + this.m_sIPAddrListBox);
        return this.m_sIPAddrListBox;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "->load()");
        this.m_sDNSEntry = "";
        this.m_sDNSListBox = "";
        this.m_vdDNSListBox = new ValueDescriptor[0];
        this.m_sIPAddrNetworkByte0 = "";
        this.m_sIPAddrNetworkByte1 = "";
        this.m_sIPAddrNetworkByte2 = "";
        this.m_sIPAddrNetworkByte3 = "";
        this.m_sIPAddrListBox = "";
        this.m_vdIPAddrListBox = new ValueDescriptor[0];
        this.initializeListBoxes();
        Trace.trace(TRACE_MASKT, "->load()");
    }

    public void save() {
    }

    private void initializeListBoxes() {
        ValueDescriptor[] listBox = null;
        Trace.trace(TRACE_MASKT, "->initializeListBoxes()");
        try {
            listBox = this.createListBox(this.getAltDNSNames(), "DNSListBox");
            if (listBox != null) {
                this.m_vdDNSListBox = listBox;
            }
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 11, e).log();
        }
        try {
            listBox = this.createListBox(this.getAltIPAddresses(), "IPAddrListBox");
            if (listBox != null) {
                this.m_vdIPAddrListBox = listBox;
            }
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 11, e).log();
        }
        Trace.trace(TRACE_MASKT, "<-initializeListBoxes()");
    }

    private ValueDescriptor[] createListBox(HashSet elements, String name) {
        int numOfElements = 0;
        ValueDescriptor[] result = null;
        int index = 0;
        if (elements != null && (numOfElements = elements.size()) > 0) {
            result = new ValueDescriptor[numOfElements];
            index = 0;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                result[index++] = CertMgtPanelUtils.createValueDescriptor(name, (String)i.next());
            }
        }
        return result;
    }

    private HashSet getAltDNSNames() throws HException {
        HashSet altNames = null;
        if (this.certificate != null) {
            altNames = this.certificate.getSubjectAltNames().getDNSNames();
        }
        if (altNames != null && altNames.size() > 0) {
            return altNames;
        }
        return null;
    }

    private HashSet getAltIPAddresses() throws HException {
        HashSet altNames = null;
        if (this.certificate != null) {
            altNames = this.certificate.getSubjectAltNames().getIPAddrNames();
        }
        if (altNames != null && altNames.size() > 0) {
            return altNames;
        }
        return null;
    }

    public void panelAction(TaskActionEvent event) {
        String elementName = null;
        String actionCommand = null;
        UserTaskManager utm = null;
        Trace.trace(TRACE_MASKT, "->panelAction(" + event + ")");
        if (event != null) {
            Trace.trace(TRACE_MASKF, "Bean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
            elementName = event.getElementName();
            actionCommand = event.getActionCommand();
            utm = this.getUserTaskManager();
            if (utm != null) {
                utm.storeAllElements();
            }
            if (actionCommand.equals("AddDNSButton") || actionCommand.equals("AddIPAddrButton") || actionCommand.equals("RemoveDNSButton") || actionCommand.equals("RemoveIPAddrButton")) {
                ModifyCertBean.handleDNSAndIPAddrListBoxes(actionCommand, elementName, utm, this, this.getMountPrefix(), this.certificate);
            } else if (elementName.equals("SubjectAltNamesOKButton")) {
                CertMgtPanelUtils.sendTaskletRequest("finishModSubjectAltNames", CertMgtPanelUtils.getSubjectAltNames(this.getDNSListBoxList(), this.getIPAddrListBoxList()), null, this.certificate, this);
            } else if (elementName.equals("CancelButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }

    public PanelBean getPanelBean() {
        return this;
    }

    private static void handleDNSAndIPAddrListBoxes(String actionCommand, String elementName, UserTaskManager utm, DNSAndIPAddrListBoxesInterface bean, String mountPrefix, ServerCert inCertificate) {
        block29: {
            ValueDescriptor[] newListBox;
            block31: {
                block32: {
                    int byte3;
                    int byte2;
                    int byte1;
                    int byte0;
                    String newEntry;
                    block30: {
                        newListBox = null;
                        newEntry = null;
                        byte0 = 0;
                        byte1 = 0;
                        byte2 = 0;
                        byte3 = 0;
                        String dNSEntry = null;
                        if (!actionCommand.equals("AddDNSButton")) break block30;
                        dNSEntry = bean.getDNSEntry();
                        if (dNSEntry != null && dNSEntry.length() > 0) {
                            newListBox = ModifyCertBean.handleAdd(utm, dNSEntry, bean.getDNSListBoxList(), "DNSListBox");
                            if (newListBox != null) {
                                bean.setDNSListBoxList(newListBox);
                                if (utm != null) {
                                    Trace.trace(TRACE_MASKD, "refreshing the list box using a mount prefix of " + mountPrefix);
                                    utm.refreshElement(mountPrefix + "DNSListBox");
                                }
                            }
                            Trace.trace(TRACE_MASKD, "clearing out the DNS entry field");
                            bean.setDNSEntry("");
                            if (utm != null) {
                                Trace.trace(TRACE_MASKD, "refreshing the DNS entry field using a mount prefix of " + mountPrefix);
                                utm.refreshElement(mountPrefix + "DNSEntry");
                            }
                        } else if (utm != null) {
                            try {
                                CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0009"), MsgType.ERROR_MESSAGE);
                            }
                            catch (HException e) {
                                new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                            }
                        }
                        break block29;
                    }
                    if (!actionCommand.equals("AddIPAddrButton")) break block31;
                    String networkByte0 = bean.getIPAddrNetworkByte0();
                    String networkByte1 = bean.getIPAddrNetworkByte1();
                    String networkByte2 = bean.getIPAddrNetworkByte2();
                    String networkByte3 = bean.getIPAddrNetworkByte3();
                    if (networkByte0 == null || networkByte1 == null || networkByte2 == null || networkByte3 == null || networkByte0.length() <= 0 || networkByte1.length() <= 0 || networkByte2.length() <= 0 || networkByte3.length() <= 0) break block32;
                    try {
                        byte0 = Integer.parseInt(networkByte0);
                        byte1 = Integer.parseInt(networkByte1);
                        byte2 = Integer.parseInt(networkByte2);
                        byte3 = Integer.parseInt(networkByte3);
                        if (byte0 >= 0 && byte0 <= 255 && byte1 >= 0 && byte1 <= 255 && byte2 >= 0 && byte2 <= 255 && byte3 >= 0 && byte3 <= 255) {
                            newEntry = networkByte0 + "." + networkByte1 + "." + networkByte2 + "." + networkByte3;
                            newListBox = ModifyCertBean.handleAdd(utm, newEntry, bean.getIPAddrListBoxList(), "IPAddrListBox");
                            if (newListBox != null) {
                                bean.setIPAddrListBoxList(newListBox);
                                if (utm != null) {
                                    Trace.trace(TRACE_MASKD, "refreshing the list box using a mount prefix of " + mountPrefix);
                                    utm.refreshElement(mountPrefix + "IPAddrListBox");
                                }
                            }
                            Trace.trace(TRACE_MASKD, "clearing out the IP address entry fields");
                            bean.setIPAddrNetworkByte0("");
                            bean.setIPAddrNetworkByte1("");
                            bean.setIPAddrNetworkByte2("");
                            bean.setIPAddrNetworkByte3("");
                            if (utm != null) {
                                Trace.trace(TRACE_MASKD, "refreshing the IP address entry fields using a mount prefix of " + mountPrefix);
                                utm.refreshElement(mountPrefix + "IPAddrNetworkByte0");
                                utm.refreshElement(mountPrefix + "IPAddrNetworkByte1");
                                utm.refreshElement(mountPrefix + "IPAddrNetworkByte2");
                                utm.refreshElement(mountPrefix + "IPAddrNetworkByte3");
                            }
                            break block29;
                        }
                        if (utm == null) break block29;
                        try {
                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0010"), MsgType.ERROR_MESSAGE);
                            break block29;
                        }
                        catch (HException e) {
                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                        }
                    }
                    catch (NumberFormatException e) {
                        if (utm == null) break block29;
                        try {
                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0010"), MsgType.ERROR_MESSAGE);
                            break block29;
                        }
                        catch (HException e2) {
                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e2).log();
                        }
                    }
                    break block29;
                }
                if (utm != null) {
                    try {
                        CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0017"), MsgType.ERROR_MESSAGE);
                    }
                    catch (HException e) {
                        new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                    }
                }
                break block29;
            }
            if (actionCommand.equals("RemoveDNSButton")) {
                newListBox = ModifyCertBean.handleDelete(utm, bean.getDNSListBox(), bean.getDNSListBoxList());
                if (newListBox != null) {
                    bean.setDNSListBoxList(newListBox);
                    if (utm != null) {
                        Trace.trace(TRACE_MASKD, "refreshing the list box using a mount prefix of " + mountPrefix);
                        utm.refreshElement(mountPrefix + "DNSListBox");
                    }
                }
            } else if (actionCommand.equals("RemoveIPAddrButton")) {
                newListBox = ModifyCertBean.handleDelete(utm, bean.getIPAddrListBox(), bean.getIPAddrListBoxList());
                if (newListBox != null) {
                    bean.setIPAddrListBoxList(newListBox);
                    if (utm != null) {
                        Trace.trace(TRACE_MASKD, "refreshing the list box using a mount prefix of " + mountPrefix);
                        utm.refreshElement(mountPrefix + "IPAddrListBox");
                    }
                }
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
    }

    private static ValueDescriptor[] handleDelete(UserTaskManager utm, String selectedLine, ValueDescriptor[] listBox) {
        int newListBoxLength = 0;
        ValueDescriptor[] newListBox = null;
        boolean deletedLine = false;
        Trace.trace(TRACE_MASKT, "->handleDelete(" + utm + ", " + selectedLine + ", " + listBox + ")");
        if (utm != null) {
            utm.storeAllElements();
        }
        if (selectedLine != null) {
            if (listBox != null) {
                newListBoxLength = listBox.length - 1;
                if (newListBoxLength >= 0) {
                    newListBox = new ValueDescriptor[newListBoxLength];
                }
                deletedLine = false;
                int j = 0;
                for (int i = 0; i < listBox.length; ++i) {
                    if (!listBox[i].getTitle().equals(selectedLine)) {
                        if (j >= newListBoxLength) continue;
                        Trace.trace(TRACE_MASKD, "copying element with a title of " + listBox[i].getTitle());
                        newListBox[j++] = listBox[i];
                        continue;
                    }
                    Trace.trace(TRACE_MASKD, "deleting element at index " + i);
                    deletedLine = true;
                }
                if (deletedLine) {
                    Trace.trace(TRACE_MASKT, "<-handleDelete(...) returning : " + newListBox);
                    return newListBox;
                }
            }
        } else if (utm != null) {
            try {
                CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0012"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0013"), MsgType.ERROR_MESSAGE);
            }
            catch (HException e) {
                new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-handleDelete(...) returning null");
        return null;
    }

    private static ValueDescriptor[] handleAdd(UserTaskManager utm, String entryToAdd, ValueDescriptor[] listBox, String name) {
        int currentListBoxLen = 0;
        ValueDescriptor[] newListBox = null;
        if (utm != null) {
            Trace.trace(TRACE_MASKD, "storing all elements");
            utm.storeAllElements();
        }
        Trace.trace(TRACE_MASKD, "entryToAdd set to " + entryToAdd);
        currentListBoxLen = 0;
        if (listBox != null) {
            currentListBoxLen = listBox.length;
        }
        Trace.trace(TRACE_MASKD, "currentListBoxLen set to " + currentListBoxLen);
        newListBox = new ValueDescriptor[currentListBoxLen + 1];
        if (currentListBoxLen > 0) {
            System.arraycopy(listBox, 0, newListBox, 0, currentListBoxLen);
        }
        newListBox[currentListBoxLen] = CertMgtPanelUtils.createValueDescriptor(name, entryToAdd);
        return newListBox;
    }
}

